/*
 * Decompiled with CFR 0.152.
 */
package com.vistara.sdk.dto.incident.attachment;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerFactory;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.vistara.sdk.dto.incident.attachment.Attachment;
import java.io.File;
import java.io.IOException;

public class AttachmentDeserializer
extends StdDeserializer<Attachment> {
    public AttachmentDeserializer() {
        super(Attachment.class);
    }

    public AttachmentDeserializer(Class<Attachment> attachmentClass) {
        super(attachmentClass);
    }

    public Attachment deserialize(JsonParser jp, DeserializationContext dctxt) throws IOException, JsonProcessingException {
        File file;
        SimpleType attachmentType = SimpleType.construct(Attachment.class);
        BeanDescription beanDesc = dctxt.getConfig().introspect((JavaType)attachmentType);
        JsonDeserializer deserializer = BeanDeserializerFactory.instance.createBeanDeserializer(dctxt, (JavaType)attachmentType, beanDesc);
        ((ResolvableDeserializer)deserializer).resolve(dctxt);
        Attachment attachment = (Attachment)deserializer.deserialize(jp, dctxt);
        if (attachment != null && (file = attachment.getFile()) != null && file.isFile() && file.exists() && attachment.getName() != null && !attachment.getName().isEmpty()) {
            File dupFile = new File(file.getParent(), attachment.getName());
            file.renameTo(dupFile);
            attachment.setFile(dupFile);
        }
        return attachment;
    }
}

