/*
 * Decompiled with CFR 0.152.
 */
package com.vistara.sdk.dto.policy;

import com.vistara.scc.model.rules.RuleOperatorType;
import com.vistara.sdk.utils.StringUtil;

public enum OperatorType {
    CONTAINS("Contains"),
    NOT_CONTAINS("Not Contains"),
    EQUALS("Equals"),
    NOT_EQUALS("Not Equals"),
    STARTS_WITH("Starts with"),
    ENDS_WITH("Ends with"),
    REGEX("Regex");

    private String name;

    private OperatorType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static OperatorType getOperatorTypeByInput(String input) {
        if (!StringUtil.isEmpty(input)) {
            for (OperatorType type : OperatorType.values()) {
                if (!type.getName().equalsIgnoreCase(input.trim()) && !type.getName().replaceAll(" ", "").equalsIgnoreCase(input.trim().replaceAll(" ", "")) && !type.name().equalsIgnoreCase(input.trim())) continue;
                return type;
            }
        }
        return REGEX;
    }

    public static RuleOperatorType getRuleOperatorType(OperatorType type) {
        if (type == CONTAINS) {
            return RuleOperatorType.CONTAINS;
        }
        if (type == NOT_CONTAINS) {
            return RuleOperatorType.NOTCONTAINS;
        }
        if (type == EQUALS) {
            return RuleOperatorType.EQUALS;
        }
        if (type == NOT_EQUALS) {
            return RuleOperatorType.NOTEQUALS;
        }
        if (type == STARTS_WITH) {
            return RuleOperatorType.STARTSWITH;
        }
        if (type == ENDS_WITH) {
            return RuleOperatorType.ENDSWITH;
        }
        if (type == REGEX) {
            return RuleOperatorType.MATCHES;
        }
        return RuleOperatorType.CONTAINS;
    }

    public static OperatorType getOperatorType(RuleOperatorType type) {
        if (type == RuleOperatorType.CONTAINS) {
            return CONTAINS;
        }
        if (type == RuleOperatorType.NOTCONTAINS) {
            return NOT_CONTAINS;
        }
        if (type == RuleOperatorType.EQUALS) {
            return EQUALS;
        }
        if (type == RuleOperatorType.NOTEQUALS) {
            return NOT_EQUALS;
        }
        if (type == RuleOperatorType.STARTSWITH) {
            return STARTS_WITH;
        }
        if (type == RuleOperatorType.ENDSWITH) {
            return ENDS_WITH;
        }
        if (type == RuleOperatorType.MATCHES) {
            return REGEX;
        }
        return CONTAINS;
    }
}

